export interface IconProp {
  label: string
  name: string
  checkbox: boolean
}

export interface DetailsProp {
  id: string
  config_attributes: string
  type: string
  type_name: string
}

export interface ConfigAttribute {
  label: string
  prop: string
  value: string
}

export interface PlatformItem {
  type: string
  type_name: string
  icon?: string
  config_attributes?: ConfigAttribute[]
  onBeforeNext?: (index: number, data: PlatformItem) => Promise<boolean> | boolean
}

export interface ScheduleMember {
  experiment_id?: string
  connect_id?: string
  type_name: string
  size: number
  cover_type: number
  name: number
  name_value: string
  status: number
  gender: number
  mobile: number
  connect_name: string
  other_fields?: OtherFields[]
}

export interface ScheduleEvent {
  experiment_id?: string
  connect_id?: string
  member_rate: string
  size: number
  cover_type: number
  event_name: string
  other_fields?: OtherFields[]
  events?: any[]
  last_event: string
}

export interface OtherFields {
  id: string
  name: string
  type: string
  format: string
  rule: any
}

export interface StudentFollow{
  follow_flag: string
  logs: any[] | undefined
  connect_id: string
  type: string
  data: any
}