import { fetchEventSource } from '@fortaine/fetch-event-source'
import { getAIUsage } from '../api'
import type { Message } from '../types'
import { ElMessage } from 'element-plus'

export function useChat(options: any) {
  const messages = ref<Message[]>([])
  const chatId = ref<string | null>(null)
  const isLoading = ref(false)

  const usages = ref({
    chart_count: 0,
    ai_creation_count: 2,
    ai_polish_count: 0,
    ai_expand_count: 0,
    ai_refresh_count: 0,
    experiment_id: 121,
    chart_max_count: 20,
    ai_creation_max_count: 5,
    ai_polish_max_count: 5,
    ai_expand_max_count: 5,
    ai_refresh_max_count: 5
  })

  async function fetchUsages() {
    const res = await getAIUsage(options)
    usages.value = res.data.detail
  }

  onMounted(() => {
    fetchUsages()
  })

  async function post(data: any) {
    isLoading.value = true
    await fetchEventSource('/api/lab/v1/experiment/marketing-ai/sky-agents-chat', {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json'
      },
      body: JSON.stringify({ ...options, ...data, chart_id: chatId.value }),
      async onopen(response) {
        if (response.ok) {
          return
        } else {
          throw response
        }
      },
      onmessage(res) {
        // console.log(res.data)
        const message = JSON.parse(res.data)
        if (message.code === 0) {
          ElMessage.error(message.message)
          return
        }
        chatId.value = message.chatId + ''
        const conversationId = message.conversationId
        const messageIndex = messages.value.findIndex(session => session.conversationId === conversationId)
        const content = message.content || ''
        // if (message.content === '\n') content = '<br/>'
        if (messageIndex === -1) {
          messages.value.push({ conversationId, role: 'bot', content, input: data.context })
        } else {
          messages.value[messageIndex].content = messages.value[messageIndex].content + content
        }
        isLoading.value = false
      },
      onclose() {
        fetchUsages()
        isLoading.value = false
      },
      onerror(err) {
        console.log(err)
        isLoading.value = false
        throw err
      }
    })
  }

  return { usages, chatId, messages, post, isLoading }
}
