import httpRequest from '@/utils/axios'

// 学生获取旅程
export function getStudentTrip() {
  return httpRequest.get('/api/lab/v1/experiment/itinerary/student-get-itinerary')
}

// 更新旅程
export function updateTrip(data: { itinerary_id: string; graph: string; status: number }) {
  return httpRequest.post('/api/lab/v1/experiment/itinerary/student-save-itinerary', data)
}

// 旅程绑定连接
export function bindTripConnections(data: { itinerary_id: string; connections_id: string }) {
  return httpRequest.post('/api/lab/v1/experiment/itinerary/student-bind-connections', data)
}

// 获取旅程模板demo
export function getTripTemplateDemo(params: { itinerary_id?: string }) {
  return httpRequest.get('/api/lab/v1/experiment/itinerary/get-itinerary-demo', { params })
}
