import fs from 'node:fs'
import path from 'node:path'
import { fileURLToPath, URL } from 'node:url'

import { defineConfig } from 'vite'
import vue from '@vitejs/plugin-vue'
// import checker from 'vite-plugin-checker'
import AutoImport from 'unplugin-auto-import/vite'
import ReactivityTransform from '@vue-macros/reactivity-transform/vite'

export default defineConfig(({ mode }) => ({
  base: mode === 'prod' ? 'https://webapp-pub.ezijing.com/website/prod/saas-dml/' : '/',
  plugins: [
    vue(),
    AutoImport({
      imports: ['vue', 'vue-router', '@vueuse/core'],
      dts: true,
      eslintrc: { enabled: true }
    }),
    ReactivityTransform()
    // checker({ vueTsc: true, eslint: { lintCommand: 'eslint "./src/**/*.{vue,js,jsx,ts,tsx}"' } })
  ],
  server: {
    open: true,
    host: 'dev.ezijing.com',
    https: {
      key: fs.readFileSync(path.join(__dirname, './https/ezijing.com.key')),
      cert: fs.readFileSync(path.join(__dirname, './https/ezijing.com.pem'))
    },
    proxy: {
      // '/api/resource': {
      //   target: 'http://com-resource-admin-test.ezijing.com/',
      //   changeOrigin: true,
      //   rewrite: path => path.replace(/^\/api\/resource/, '')
      // },
      '/api': 'https://saas-dml.ezijing.com'
    }
  },
  resolve: {
    alias: {
      '@': fileURLToPath(new URL('./src', import.meta.url))
    }
  }
}))
