import { getMetaUserAttrList, getMetaEventList, getTagList } from '@/api/base'

interface AttrType {
  id: string
  name: string
  type: string
  format: string
  english_name: string
  pinyin: string
}
const userAttrList = ref<AttrType[]>([])
export function useUserAttr() {
  function fetchUserAttrList() {
    getMetaUserAttrList().then((res: any) => {
      userAttrList.value = res.data.items
    })
  }
  onMounted(() => {
    if (!userAttrList.value?.length) fetchUserAttrList()
  })
  return { fetchUserAttrList, userAttrList }
}

interface MetaEvent {
  id: string
  name: string
  english_name: string
  pinyin: string
  event_attrs: AttrType[]
}
const metaEventList = ref<MetaEvent[]>([])
export function useMetaEvent() {
  function fetchMetaEventList() {
    getMetaEventList().then((res: any) => {
      metaEventList.value = res.data.items
    })
  }
  onMounted(() => {
    if (!metaEventList.value?.length) fetchMetaEventList()
  })
  return { fetchMetaEventList, metaEventList }
}

const tagList = ref([])
export function useTag() {
  function fetchTagList() {
    getTagList({ check_role: true }).then((res: any) => {
      tagList.value = res.data.items
    })
  }
  onMounted(() => {
    if (!tagList.value?.length) fetchTagList()
  })
  return { fetchTagList, tagList }
}
