import type { Operator } from '@/types'

export interface Group {
  id: string
  name: string
  type_id: string
  status: string
  type: '1' | '2'
  update_status: string // '1' | '2'
  update_rule: string
  created_time: string
  created_operator: Operator
  updated_time: string
  updated_operator: Operator
  user_attr_rule?: string
  event_attr_rule?: string
  tag_rule?: string
}

export type GroupListRequest = Pick<Group, 'id' | 'name'> & { experiment_id?: string }

// 静态群组
export type StaticGroupUpdateRequest = Pick<Group, 'id' | 'name' | 'status'> & {
  experiment_id?: string
}
export type StaticGroupCreateRequest = Omit<StaticGroupUpdateRequest, 'id'>

// 动态群组
export type DynamicGroupUpdateRequest = Pick<
  Group,
  'id' | 'name' | 'update_status' | 'update_rule' | 'user_attr_rule' | 'event_attr_rule' | 'tag_rule' | 'status'
> & {
  experiment_id?: string
}
export type DynamicGroupCreateRequest = Omit<DynamicGroupUpdateRequest, 'id'>

export interface GroupMember {
  id: string
  name: string
  gender: string
  mobile: string
  status: string
  created_time: string
  created_operator: Operator
  updated_time: string
  updated_operator: Operator
}
