import httpRequest from '@/utils/axios'
import type {
  LabelTypeListRequest,
  LabelTypeCreateRequest,
  LabelTypeUpdateRequest,
  LabelListRequest,
  LabelCreateRequest,
  LabelUpdateRequest
} from './types'

// 获取标签类型列表
export function getLabelTypeList(params?: LabelTypeListRequest) {
  return httpRequest.get('/api/lab/v1/experiment/tag-type/list', { params })
}

// 创建标签类型
export function createLabelType(data: LabelTypeCreateRequest) {
  return httpRequest.post('/api/lab/v1/experiment/tag-type/create', data)
}

// 更新标签类型
export function updateLabelType(data: LabelTypeUpdateRequest) {
  return httpRequest.post('/api/lab/v1/experiment/tag-type/update', data)
}

// 更新标签类型
export function deleteLabelType(data: { id: string }) {
  return httpRequest.post('/api/lab/v1/experiment/tag-type/delete', data)
}

// 获取标签列表
export function getLabelList(params?: LabelListRequest) {
  return httpRequest.get('/api/lab/v1/experiment/tag/list', { params })
}

// 创建标签
export function createLabel(data: LabelCreateRequest) {
  return httpRequest.post('/api/lab/v1/experiment/tag/create', data)
}

// 更新标签
export function updateLabel(data: LabelUpdateRequest) {
  return httpRequest.post('/api/lab/v1/experiment/tag/update', data)
}

// 更新标签
export function deleteLabel(data: { id: string }) {
  return httpRequest.post('/api/lab/v1/experiment/tag/delete', data)
}

// 获取标签数据信息
export function getLabelStatistics(params: { id: string }) {
  return httpRequest.get('/api/lab/v1/experiment/tag/statistics', { params })
}

// 获取标签规则
export function getLabelRule(params: { id: string }) {
  return httpRequest.get('/api/lab/v1/experiment/tag/rule', { params })
}

// 更新标签规则
export function updateLabelRule(data: { id: string; user_attr_rule: string; event_attr_rule: string }) {
  return httpRequest.post('/api/lab/v1/experiment/tag/save-rule', data)
}
