import httpRequest from '@/utils/axios'

// 事件属性列表
export function getMetaEvent(params: { name?: string; status?: string; experiment_connection_id?: string; page?: number; page_size?: number }) {
  return httpRequest.get('/api/experiment/v1/experiment/meta-event/list', { params: { experiment_id: '7025368348925886464', ...params } })
}

// 创建事件属性
export function createMetaEvent(data: { name: string; english_name: string; experiment_connection_id: string; status: string; }) {
  return httpRequest.post('/api/experiment/v1/experiment/meta-event/create', data)
}

// 时间列表
export function getConnectionsList() {
  return httpRequest.get('/api/experiment/v1/experiment/meta-event/connections')
}

// 修改事件属性
export function updateMetaEvent(data: { id?: string; name: string; english_name: string; status: string; }) {
  return httpRequest.post('/api/experiment/v1/experiment/meta-event/update', data)
}

// 删除
export function deleteMetaEvent(data: { id?: string }) {
  return httpRequest.post('/api/experiment/v1/experiment/meta-event/delete', data)
}

// 事件属性列表
export function getMetaEventDetail(params: { id: string }) {
  return httpRequest.get('/api/experiment/v1/experiment/meta-event/view', { params })
}

// 保存属性
export function updateAttributes(data: { id: string; attributes: string }) {
  return httpRequest.post('/api/experiment/v1/experiment/meta-event/attributes', data)
}

// 事件属性列表
export function getIsDeleteAttribute(params: { id: string }) {
  return httpRequest.get('/api/experiment/v1/experiment/meta-event/can-delete-attribute', { params })
}