import httpRequest from '@/utils/axios'
import type { TripTemplateListRequest, TripTemplateCreateRequest, TripTemplateUpdateRequest } from './types'
// 获取旅程模板列表
export function getTripTemplateList(params: TripTemplateListRequest) {
  return httpRequest.get('/api/lab/v1/experiment/itinerary/list', { params })
}

// 创建旅程模板
export function createTripTemplate(data: TripTemplateCreateRequest) {
  return httpRequest.post('/api/lab/v1/experiment/itinerary/create', data)
}

// 更新旅程模板
export function updateTripTemplate(data: TripTemplateUpdateRequest) {
  return httpRequest.post('/api/lab/v1/experiment/itinerary/update', data)
}
