import { getFilterList } from '../api'

export interface FilterItem {
  id: string
  name: string
}

export function useFilterList(leader = 0) {
  // 赛项
  const competitions = ref<FilterItem[]>([])
  // 学校
  const schools = ref<FilterItem[]>([])
  // 状态
  const status = ref<FilterItem[]>([])
  getFilterList({ leader }).then(res => {
    competitions.value = res.data.competition
    schools.value = res.data.school
    status.value = res.data.status
  })
  return { competitions, schools, status }
}
