import httpRequest from '@/utils/axios'
import type { ContestantCreateParams, ContestantUpdateParams } from './types'

// 获取参赛选手列表
export function getContestantList(params?: { student_name?: string; page?: number; 'per-page'?: number }) {
  return httpRequest.get('/api/resource/v1/backend/competition-competitor/list', { params })
}

// 获取参赛选手列表
export function getContestant(params: { id: string }) {
  return httpRequest.get('/api/resource/v1/backend/competition-competitor/detail', { params })
}

// 创建参赛选手
export function createContestant(data: ContestantCreateParams) {
  return httpRequest.post('/api/resource/v1/backend/competition-competitor/create', data)
}

// 修改参赛选手
export function updateContestant(data: ContestantUpdateParams) {
  return httpRequest.post('/api/resource/v1/backend/competition-competitor/update', data)
}

// 批量导入参赛选手
export function uploadContestant(data: { file: File }) {
  return httpRequest.post('/api/resource/v1/backend/competition-competitor/import-competitors', data, {
    headers: { 'Content-Type': 'multipart/form-data' }
  })
}
