export interface CourseType {
  id: string
  name: string
  cover: string
  experiments: ExperimentType[]
}

export interface ExperimentType {
  id: string
  name: string
  course_id: string
  organ_id: string
}

export interface ExperimentBookType {
  id: string
  name: string
  size: string
  type: string
  url: string
}

export interface ExperimentVideoType {
  id: string
  name: string
  size: string
  type: string
  source_id: string
  length: number
  cover: string
}

export interface PlayInfo {
  BitDepth: number
  Bitrate: string
  CreationTime: string
  Definition: string
  Duration: string
  Encrypt: number
  Format: string
  Fps: string
  HDRType: string
  Height: number
  JobId: string
  ModificationTime: string
  NarrowBandType: string
  PlayURL: string
  PreprocessStatus: string
  Size: number
  Specification: string
  Status: string
  StreamType: string
  Width: number
}

export interface ExperimentDiscussType {
  content: string
  created_operator: string
  created_time: string
  id: string
  is_reply: string
  replies: ExperimentDiscussCommentType[]
  reply_count: number
  sso_user: UserType
  student_id: string
  title: string
  updated_time: string
}

export interface ExperimentDiscussCommentType {
  content: string
  created_time: string
  discussion_id: string
  id: string
  role: string
  sso_id: string
  sso_user: UserType
}
export interface UserType {
  avatar: string
  id: string
  nickname: string
  real_name: string
  username: string
}

export interface ExperimentRecord {
  experiment_id: string
  student_id: string
  commit_time: string
  pictures: ExperimentRecordFile[]
  file: ExperimentRecordFile
  checker_id: string
  check_time: string
  score_details: { operate: number; result: number; file: number }
  score: string
  status: 0 | 1 | 2
  checker_user: UserType
  experiment: {
    id: string
    name: string
    score: number
    length: number
  }
  course: CourseType
  student: ExperimentStudent
  is_check_report: boolean
}
export interface ExperimentRecordFile {
  url: string
  name: string
  upload_time: string
}

export interface ExperimentStudent {
  id: string
  name: string
  sno_number: string
  specialty: IdName
  classes: IdName[]
}

// 实验信息
export interface ExperimentInfo {
  id: string
  name: string
  length: number
  type: number
  type_level: string
  score: number
  status: number
  purpose: string
  requirements: string
  content: string
  procedure: string
  report_upload_way: 1 | 2
  teachers: IdName[]
  course: IdName
  organization: IdName
  student: ExperimentStudent
  is_commit_report: boolean
  is_commit: boolean
}

interface IdName {
  id: string
  name: string
}
