import httpRequest from '@/utils/axios'

// 获取用户信息
export function getUser() {
  return httpRequest.get('/api/lab/v1/common/permission/role')
}

// 退出登录
export function logout() {
  return httpRequest.get('/api/passport/rest/logout')
}

// 获取oss token
export function getToken() {
  return httpRequest.get('/api/usercenter/aliyun/assume-role')
}

// 获取oss signature
export function getSignature() {
  return httpRequest.get('/api/usercenter/aliyun/get-signature')
}

// 图片上传
export async function uploadFile(data: Record<string, any>) {
  await httpRequest.post('https://webapp-pub.oss-cn-beijing.aliyuncs.com', data, {
    withCredentials: false,
    headers: { 'Content-Type': 'multipart/form-data' }
  })
  return data
}
// 获取公共字典列表
export function getMapList() {
  return httpRequest.get('/api/resource/v1/util/get-data-dictionary-list')
}

// 获取上传视频凭证
export function getUploadVideoAuth(data: { title: string; file_name: string }) {
  return httpRequest.post('/api/lab/v1/teacher/video/auth-create', data)
}

// 刷新上传视频的地址凭证
export function updateUploadVideoAuth(data: { source_id: string }) {
  return httpRequest.post('/api/lab/v1/teacher/video/create-auth', data)
}

// 获取项目列表
export function getProjectList(params: { organization_id?: string; project_id?: string }) {
  return httpRequest.get('/api/resource/v1/util/members', { params })
}

// 获取赛项列表
export function getContestList(params?: { name?: string }) {
  return httpRequest.get('/api/resource/v1/backend/competition/menu-list', { params })
}

// 获取待办消息
// https://gitlab.ezijing.com/root/api-documents/-/blob/master/messages/api/%E4%B8%80%E6%9C%9F%E7%AB%99%E5%86%85%E4%BF%A1%E6%8E%A5%E5%8F%A3%E6%96%87%E6%A1%A3.md#%E8%8E%B7%E5%8F%96%E7%AB%99%E5%86%85%E4%BF%A1%E6%B6%88%E6%81%AF%E5%88%97%E8%A1%A8
export function getMessages(params: {
  source: string
  page?: number
  limit?: number
  is_read?: 0 | 1 | 9999
  is_platform?: 0 | 1 | 9999
  start_time?: string
  end_time?: string
}) {
  return httpRequest.get('https://microservices-message-service-api.ezijing.com/v1/messages/intra-station-messages', {
    params
  })
}

export function readMessages(params: { message_id: string }) {
  return httpRequest.get('https://microservices-message-service-api.ezijing.com/v1/messages/read', {
    params
  })
}
