import type { RouteRecordRaw } from 'vue-router'
import AppLayout from '@/components/layout/Index.vue'
import { useAppConfig } from '@/composables/useAppConfig'
const appConfig = useAppConfig()

export const routes: Array<RouteRecordRaw> = [
  {
    path: '/',
    component: AppLayout,
    props: { sidebar: false, footer: appConfig.isGame },
    children: [{ path: '', component: () => import('./views/Index.vue') }]
  }
]
