import { getProjectList } from '@/api/base'

import { useUserStore } from '@/stores/user'

// 部门信息
interface DepartmentType {
  id: string
  name: string
  organizations: OrganizationType[]
}

// 机构信息
interface OrganizationType {
  id: string
  name: string
}
// 成员信息
interface MemberType {
  id: string
  name: string
}
const store = useUserStore()

const members = ref<MemberType[]>([])
const departments = ref<DepartmentType[]>([])
const organizations = ref<OrganizationType[]>([])
export function useGetProjectList() {
  !departments.value.length &&
    getProjectList({ organization_id: store.organization?.id, project_id: store.project?.id }).then((res: any) => {
      members.value = res.data.members
      departments.value = res.data.departments
      organizations.value = res.data.departments.reduce((result: OrganizationType[], item: DepartmentType) => {
        return result.concat(item.organizations)
      }, [])
    })

  return { members, departments, organizations }
}
