import type { SystemDictionary } from '@/types'

export interface ContestItemTeacher {
  id: string
  name: string
}

export interface ContestItem {
  id: string
  name: string
  type: string
  start_range: number
  end_range: number
  start_at: number
  end_at: number
  operational_start_time: number
  operational_end_time: number
  apply_expiration_date: number
  status: string
  logo: string
  cover: string
  train_platform_uri: string
  competition_uri: string
  publish_status: string
  created_operator: string
  updated_operator: string
  created_time: string
  updated_time: string
  teachers: ContestItemTeacher[]
  host_unit: SystemDictionary
  technical_support_unit: SystemDictionary
  organizers: SystemDictionary[]
  apply_count: number
  expert_count: number
  train_platform_configs: any[]
  competition_platform_configs: any[]
  is_switchable_theory_practice: string,
  is_customer_anti_cheat: string
  extended_field: any
}

export interface ContestCreateParams {
  name: string
  host_unit_id: string
  organizer_ids: string
  technical_support_unit_id: string
  type: string
  start_range: number
  end_range: number
  start_at: number
  end_at: number
  apply_expiration_date: number
  status: string
  logo: string
  cover: string
  // train_platform_uri: string
  // competition_uri: string
  teacher_ids: string[]
  train_platform_configs: any[]
  competition_platform_configs: any[]
}

export type ContestUpdateParams = ContestCreateParams & { id: string }

export interface ContestBookItem {
  id: string
  competition_id: string
  name: string
  type: string
  url: string
  status: string
  created_operator: string
  created_time: string
  updated_time: string
  create_user: User
}

export interface ContestBookUpdateParams {
  id?: string
  competition_id: string
  name: string
  url: string
  type: string
  status: string
}

export interface User {
  id: string
  username: string
  nickname: string
  real_name: string
}

export interface ContestVideoItem {
  id: string
  competition_id: string
  name: string
  duration: string
  size: string
  cover: string
  type: string
  status: string
  source_id: string
  created_operator: string
  created_time: string
  updated_time: string
  create_user: User
}

export interface ContestVideoCreateParams {
  competition_id: string
  name: string
  type: string
  status: string
  duration: number
  source_id: string
}

export type ContestVideoUpdateParams = ContestVideoCreateParams & { id: string }
