import type { SystemDictionary } from '@/types'

export interface Contest {
  apply_expiration_date: string
  competition_uri: string
  cover: string
  end_at: string
  end_range: string
  host_unit: SystemDictionary
  id: string
  login_id: string
  logo: string
  name: string
  org_name: string
  organizers: SystemDictionary[]
  start_at: string
  start_range: string
  student_id: string
  student_name: string
  technical_support_unit: SystemDictionary
  train_platform_uri: string
  type: string
  mode: string
}

export type ContestJoinParams = {
  competition_id: string
  mode: string
  picture: string
  grade: string
  teacher_name: string
  sms_code: string
}

export type ExperimentBookType = {
  id: string
  name: string
  competition_id: string
  type: string
  url: string
}

export interface ExperimentVideoType {
  id: string
  name: string
  size: string
  type: string
  source_id: string
  length: number
  cover: string
}

export interface PlayInfo {
  BitDepth: number
  Bitrate: string
  CreationTime: string
  Definition: string
  Duration: string
  Encrypt: number
  Format: string
  Fps: string
  HDRType: string
  Height: number
  JobId: string
  ModificationTime: string
  NarrowBandType: string
  PlayURL: string
  PreprocessStatus: string
  Size: number
  Specification: string
  Status: string
  StreamType: string
  Width: number
}

export interface ExperimentDiscussType {
  content: string
  created_operator: string
  created_time: string
  id: string
  is_reply: string
  competitionDiscussionReplies: ExperimentDiscussCommentType[]
  reply_count: number
  sso_user: UserType
  student_id: string
  title: string
  updated_time: string
}

export interface ExperimentDiscussCommentType {
  content: string
  created_time: string
  discussion_id: string
  id: string
  role: string
  sso_id: string
  sso_user: UserType
}
export interface UserType {
  avatar: string
  id: string
  nickname: string
  real_name: string
  username: string
}

export type ExperimentRecord = {
  competition_id: string
  created_time: string
  id: string
  pictures: ExperimentRecordFile[]
  student_id: string
  updated_time: string
}

export interface ExperimentRecordFile {
  url: string
  name: string
  upload_time: string
  size?: number
}
