import type { RouteRecordRaw } from 'vue-router'
import AppLayout from '@/components/layout/Index.vue'

export const routes: Array<RouteRecordRaw> = [
  {
    path: '/student/contest',
    component: AppLayout,
    children: [
      { path: '', component: () => import('./views/Index.vue') },
      { path: 'join', component: () => import('./views/Join.vue') },
      { path: 'lab/:id', component: () => import('./views/Lab.vue'), props: true },
      { path: 'score', component: () => import('./views/Score.vue') }
    ]
  }
]
