import type { IMenuItem } from '@/types'
import { defineStore } from 'pinia'
import { useUserStore } from '@/stores/user'
import { useAppConfig } from '@/composables/useAppConfig'

interface State {
  studentMenus: IMenuItem[]
  adminMenus: IMenuItem[]
}

// 学生菜单
const studentMenus: IMenuItem[] = [
  { name: '首页', path: '/' },
  { name: '我的实验', path: '/student/lab' },
  { name: '理论学习', path: import.meta.env.VITE_SAAS_LEARN_URL },
  { name: '我的大赛', path: '/student/contest' },
  { name: '大赛成绩查询', path: '/student/contest/score' },
]
// 管理员菜单
const adminMenus: IMenuItem[] = [
  { name: '首页', path: '/' },
  {
    name: '我的实验',
    path: '/admin/lab',
    tag: ['v1-backend-experiment', 'v1-teacher'],
    children: [
      { name: '实验管理', path: '/admin/lab/experiment', tag: 'v1-backend-experiment' },
      { name: '案例原文管理', path: '/admin/lab/case', tag: 'teacher-experiment-cases' },
      { name: '实验指导书管理', path: '/admin/lab/book', tag: 'v1-teacher-book' },
      { name: '实验操作视频管理', path: '/admin/lab/video', tag: 'v1-teacher-video' },
      { name: '实验讨论交流', path: '/admin/lab/discuss', tag: 'v1-teacher-discussion' },
      { name: '实验成绩管理', path: '/admin/lab/score', tag: 'v1-teacher-record' },
      { name: '实验监控', path: '/admin/lab/dashboard' },
      { name: '案例管理', path: '/admin/lab/example' },
    ],
  },
  {
    name: '技能大赛',
    path: '/admin/contest',
    children: [
      { name: '赛项管理', path: '/admin/contest/items', tag: 'competition' },
      { name: '参赛选手管理', path: '/admin/contest/contestants', tag: 'competition-competitor' },
      { name: '评分专家管理', path: '/admin/contest/experts', tag: 'expert' },
      { name: '大赛训练答疑', path: '/admin/contest/discuss', tag: 'v1-teacher-train-discussion' },
      { name: '大赛监控', path: '/admin/contest/dashboard', tag: 'v1-expert-statistic' },
      { name: '大赛评分', path: '/admin/contest/check', tag: 'v1-expert-check' },
      { name: '大赛发布成绩', path: '/admin/contest/score', tag: 'v1-expert-score' },
      { name: '客户端日志', path: '/admin/contest/log', tag: '' },
    ],
  },
  {
    name: '成绩分析',
    path: '/admin/contest/analyze',
    children: [
      { name: '赛项成绩画像', path: '/admin/contest/analyze/score' },
      { name: '学生个人成绩画像', path: '/admin/contest/analyze/student' },
    ],
  },
]
const appConfig = useAppConfig()

export const useMenuStore = defineStore('menu', {
  state: (): State => ({ studentMenus, adminMenus }),
  getters: {
    menus: (state): IMenuItem[] => {
      const userStore = useUserStore()
      if (userStore.role?.id === 1) {
        return appConfig.studentMenus || state.studentMenus
      } else {
        return appConfig.adminMenus || state.adminMenus
      }
    },
  },
})
