import { getExperimentCourseList } from '../api'

import { useUserStore } from '@/stores/user'

interface CourseType {
  id: string
  name: string
}
const store = useUserStore()

const courses = ref<CourseType[]>([])

export function useGetCourseList() {
  !courses.value.length &&
    getExperimentCourseList({ organ_id: store.organization?.id }).then((res: any) => {
      courses.value = res.data
    })
  return { courses }
}
