import type { RouteRecordRaw } from 'vue-router'
import AppLayout from '@/components/layout/Index.vue'

export const routes: Array<RouteRecordRaw> = [
  {
    path: '/admin/system',
    component: AppLayout,
    redirect: '/admin/system/experiment',
    children: [
      { path: 'experiment', component: () => import('./views/Index.vue') },
      { path: 'experiment/:id', component: () => import('./views/View.vue'), props: true },
      { path: 'experiment/group/:id', component: () => import('./views/Group.vue'), props: true }
    ]
  }
]
