const appConfigList = [
  {
    title: '商业数据分析实验室',
    logo: 'https://zws-imgs-pub.ezijing.com/pc/base/ezijing-logo.svg',
    hosts: ['saas-lab']
  },
  {
    system: 'x',
    title: '1+X实训平台（中级）',
    logo: 'https://zws-imgs-pub.ezijing.com/pc/base/ezijing-logo.svg',
    hosts: ['saas-x'],
    studentMenus: [
      { name: '首页', path: '/' },
      { name: '我的实验', path: '/student/lab' },
      { name: '理论学习', path: 'https://saas-learn.ezijing.com' }
    ],
    adminMenus: [
      { name: '首页', path: '/' },
      {
        name: '我的实验',
        path: '/admin/lab',
        tag: ['v1-backend-experiment', 'v1-teacher'],
        children: [
          { name: '实验管理', path: '/admin/lab/experiment', tag: 'v1-backend-experiment' },
          { name: '案例原文管理', path: '/admin/lab/case', tag: 'teacher-experiment-cases' },
          { name: '实验指导书管理', path: '/admin/lab/book', tag: 'v1-teacher-book' },
          { name: '实验操作视频管理', path: '/admin/lab/video', tag: 'v1-teacher-video' },
          { name: '实验讨论交流', path: '/admin/lab/discuss', tag: 'v1-teacher-discussion' },
          { name: '实验成绩管理', path: '/admin/lab/score', tag: 'v1-teacher-record' }
        ]
      }
    ]
  },
  {
    system: 'game',
    title: '商业数据分析竞赛平台',
    hosts: ['saas-game']
  },
  {
    system: 'dml',
    title: '数字营销实验室',
    logo: 'https://zws-imgs-pub.ezijing.com/pc/base/ezijing-logo.svg',
    hosts: ['saas-dml-web']
  }
]

export function useAppConfig() {
  const found = appConfigList.find(item => {
    return item.hosts.find(host => location.host.includes(host))
  })

  const appConfig = found || appConfigList[0]

  return { ...appConfig }
}
