import httpRequest from '@/utils/axios'
import type { VideoCreateItem } from './types'

// 获取课程列表
export function getCourseList() {
  return httpRequest.get('/api/lab/v1/teacher/video/courses')
}
// 获取实验列表
export function getExperimentList(params: { course_id?: string }) {
  return httpRequest.get('/api/lab/v1/teacher/video/experiments', { params })
}
// 获取操作视频列表
export function getVideoList(params?: { name?: string; experiment_id?: string; page?: number; page_size?: number }) {
  return httpRequest.get('/api/lab/v1/teacher/video/list', { params })
}
// 获取操作视频详情
export function getVideo(params: { id: string }) {
  return httpRequest.get('/api/lab/v1/teacher/video/view', { params })
}

// 创建操作视频
export function createVideo(data: VideoCreateItem) {
  return httpRequest.post('/api/lab/v1/teacher/video/create', data)
}

// 更新操作视频
export function updateVideo(data: VideoCreateItem) {
  return httpRequest.post('/api/lab/v1/teacher/video/update', data)
}
