import httpRequest from '@/utils/axios'

// 获取课程列表
export function getCourseList() {
  return httpRequest.get('/api/lab/v1/student/course/all')
}

// 获取实验指导书
export function getExperimentBook(params: { experiment_id: string }) {
  return httpRequest.get('/api/lab/v1/student/experiment-book/detail', { params })
}

// 获取实验视频
export function getExperimentVideoList(params: { experiment_id: string }) {
  return httpRequest.get('/api/lab/v1/student/experiment-video/all', { params })
}
// 获取实验视频播放信息
export function getExperimentVideoPlayInfo(params: { source_id: string }) {
  return httpRequest.get('/api/lab/v1/student/experiment-video/replay-list', { params })
}

// 获取实验讨论交流
export function getExperimentDiscussList(params: {
  experiment_id: string
  tag: number
  page?: number
  'per-page'?: number
}) {
  return httpRequest.get('/api/lab/v1/student/experiment-topic/list', { params })
}
// 发表新话题
export function addExperimentDiscuss(data: { experiment_id: string; title: string; content: string }) {
  return httpRequest.post('/api/lab/v1/student/experiment-topic/issue', data)
}
// 发表回复
export function addExperimentDiscussComment(data: { discussion_id: string; content: string }) {
  return httpRequest.post('/api/lab/v1/student/experiment-topic/comment', data)
}

// 获取实验记录
export function getExperimentRecord(params: { experiment_id: string }) {
  return httpRequest.get('/api/lab/v1/student/experiment-record/detail', { params })
}

// 截图
export function uploadExperimentPicture(data: { experiment_id: string; pictures: string }) {
  return httpRequest.post('/api/lab/v1/student/experiment-record/upload-pictures', data)
}

// 上传实验报告
export function uploadExperimentReport(data: { experiment_id: string; file: string }) {
  return httpRequest.post('/api/lab/v1/student/experiment-record/upload-report', data)
}

// 提交实验记录
export function submitExperimentRecord(data: { experiment_id: string }) {
  return httpRequest.post('/api/lab/v1/student/experiment-record/submit', data)
}
