import httpRequest from '@/utils/axios'

// 获取讨论交流列表
export function getDiscussList(params?: {
  competition_id?: string
  student_name?: string
  page?: number
  page_size?: number
}) {
  return httpRequest.get('/api/lab/v1/teacher/train-discussion/list', { params })
}

// 获取筛选条件
export function getFilterList() {
  return httpRequest.get('/api/lab/v1/teacher/train-discussion/competitions')
}

// 获取讨论交流详情
export function getDiscuss(params: { id: string; page?: number; page_size?: number }) {
  return httpRequest.get('/api/lab/v1/teacher/train-discussion/view', { params })
}

// 获取讨论交流详情
export function submitDiscussComment(data: { id: string; content: string }) {
  return httpRequest.post('/api/lab/v1/teacher/train-discussion/comment', data)
}
