export interface ExperimentItemTeacher {
  id: string
  name: string
}

export interface ExperimentItem {
  course_id: string
  course_name: string
  created_operator: string
  created_operator_name: string
  created_time: string
  delete_time: string
  id: string
  length: string
  name: string
  organ_id: string
  organ_id_name: string
  project_id: string
  project_id_name: string
  score: string
  status: string
  status_name: string
  teacher: ExperimentItemTeacher[]
  type: string
  type_name: string
  updated_operator: string
  updated_operator_name: string
  updated_time: string
  purpose: string
  requirements: string
  content: string
  procedure: string
  stu_commit_count: number
  exam_status?: string
}

export interface ExperimentCreateItem {
  id?: string
  organ_id: string
  status: string
  course_id: string
  name: string
  length: number
  type: string
  score: number
  teachers_id: string
  teachers_ids?: string[]
  purpose: string
  requirements: string
  content: string
  procedure: string
  exam_status: string
}

export interface ClassItem {
  code: string
  created_operator: string
  created_operator_name: string
  created_time: string
  delete_time: string
  id: string
  name: string
  organ_id: string
  organ_id_name: string
  project_id: string
  project_id_name: string
  specialty_id: string
  specialty_id_name: string
  start_year: string
  start_year_name: string
  status: string
  status_name: string
  student_nums: number
  teacher_id: string
  teacher_id_name: string
  updated_operator: string
  updated_operator_name: string
  updated_time: string
}

export interface StudentItem {
  birthday: string
  city: string
  city_name: string
  class_id: string
  class_id_name: string
  county: string
  county_name: string
  created_operator: string
  created_operator_name: string
  created_time: string
  delete_time: string
  gender: string
  gender_name: string
  id: string
  id_number: string
  id_type: string
  id_type_name: string
  mobile: string
  name: string
  organ_id: string
  organ_id_name: string
  project_id: string
  project_id_name: string
  province: string
  province_name: string
  sno_number: string
  specialty_id: string
  specialty_id_name: string
  sso_id: string
  status: string
  status_name: string
  updated_operator: string
  updated_operator_name: string
  updated_time: string
}

export interface GroupItem {
  class_id: string
  created_operator: string
  created_time: string
  experiment_id: string
  id: string
  name: string
  status: string
  student_num: number
  updated_operator: string
  updated_time: string
  experiment_name?: string
  course_name?: string
  class_name?: string
}
