import httpRequest from '@/utils/axios'

// 获取实验记录列表
export function getExperimentRecordList(params?: {
  course_id?: string
  experiment_id?: string
  specialty_id?: string
  class_id?: string
  student_name?: string
  page?: number
  page_size?: number
}) {
  return httpRequest.get('/api/lab/v1/teacher/record/list', { params })
}

// 获取筛选条件
export function getFilterList() {
  return httpRequest.get('/api/lab/v1/teacher/record/search-list')
}

// 获取实验记录详情
export function getExperimentRecord(params: { experiment_id: string; student_id: string }) {
  return httpRequest.get('/api/lab/v1/teacher/record/view', { params })
}

// 实验记录评分
export function checkExperimentRecord(data: { experiment_id: string; student_id: string; operate: number; result: number; file: number }) {
  return httpRequest.post('/api/lab/v1/teacher/record/check', data)
}

// 批量导入实验记录评分
export function uploadCheckExperimentRecord(data: { file: File }) {
  return httpRequest.post('/api/lab/v1/teacher/record/upload', data, {
    headers: { 'Content-Type': 'multipart/form-data' }
  })
}

// 获取实验准备
export function getExperimentPrepare(params: { experiment_id: string; student_id: string }) {
  return httpRequest.get('/api/lab/v1/teacher/experiment/pre-detail', { params })
}

// 获取实验结果
export function getExperimentResult(params: { experiment_id: string; student_id: string }) {
  return httpRequest.get('/api/lab/v1/teacher/experiment/result-detail', { params })
}

// 获取实验报告
export function getExperimentReport(params: { experiment_id: string; student_id: string }) {
  return httpRequest.get('/api/lab/v1/teacher/experiment/report-achievement', { params })
}
// 批改学员实验报告成绩
export function updateExperimentReport(data: { experiment_id: string; student_id: string; score_detail: string; comment: string }) {
  return httpRequest.post('/api/lab/v1/teacher/experiment/report-check', data)
}

// 获取实验评分模板
export function getExperimentScoreTemplate(params: { experiment_id: string }) {
  return httpRequest.get('/api/lab/v1/teacher/experiment/score-template', { params })
}

// 获取实验成绩
export function getExperimentScore(params: { experiment_id: string; student_id: string }) {
  return httpRequest.get('/api/lab/v1/teacher/experiment/achievement', { params })
}
// 批改学员实验成绩
export function updateExperimentScore(data: { experiment_id: string; student_id: string; score_details: string }) {
  return httpRequest.post('/api/lab/v1/teacher/experiment/achievement-check', data)
}

// 获取学员信息
export function getStudentInfo(params: { experiment_id: string; student_id: string }) {
  return httpRequest.get('/api/lab/v1/teacher/student/detail', { params })
}

// 获取学员信息
export function getQuestionList(params: { experiment_id: string; student_id: string }) {
  return httpRequest.get('/api/lab/v1/teacher/experiment-question/list', { params })
}

// 打分
export function updateQuestionScore(data: { question_id: string; student_id: string; commit_score: string }) {
  return httpRequest.post('/api/lab/v1/teacher/experiment-question/check', data)
}

// 同步学生分数
export function asyncStudentResult(data: { experiment_id: string; student_id: string }) {
  return httpRequest.post('/api/lab/v1/teacher/experiment-question/async-student-result', data)
}

export function getStudentTicket(params: { student_id: string }) {
  return httpRequest.get('/api/lab/v1/teacher/system/get-student-ticket', { params })
}

// 批量导出实验记录评分
export function exportExperimentRecord(params: { experiment_id: string }) {
  return httpRequest.get('/api/lab/v1/teacher/record/download', { params })
}

// 同步理论成绩
export function syncExperimentExam(params: { experiment_id: string }) {
  return httpRequest.get('/api/lab/v1/teacher/record/sync-theory-score', { params })
}

// 重置
export function recordReject(params: { experiment_id: string; student_id: string }) {
  return httpRequest.get('/api/lab/v1/teacher/record/reject', { params })
}
