// json to array
export const json2Array = function (data: any, isValueToNumber = true) {
  return Object.keys(data).map(value => ({ label: data[value], value: isValueToNumber ? parseInt(value) : value }))
}

// 参赛模式
export const contestMode: Record<string, any> = {
  1: '个人赛'
}
// 参赛模式列表
export const contestModeList = json2Array(contestMode, false)

// 评分规则
export const scoreRule: Record<string, any> = {
  1: '平均法',
  2: '加权平均法',
  3: '综合得分法',
  4: '最高分'
}
// 参赛模式列表
export const scoreRuleList = json2Array(scoreRule, false)
