import { getCourseExperimentList } from '../api'

interface ExperimentType {
  id: string
  name: string
}

export function useGetCourseExperimentList() {
  const courseExperiments = ref<ExperimentType[]>([])
  function updateCourseExperiments(courseId: string) {
    getCourseExperimentList({ course_id: courseId }).then((res: any) => {
      courseExperiments.value = res.data
    })
  }
  return { courseExperiments, updateCourseExperiments }
}
