import { getExperimentCourseList } from '../api'

import { useUserStore } from '@/stores/user'

interface CourseType {
  id: string
  name: string
}
const store = useUserStore()

const courses = ref<CourseType[]>([])

export function useGetCourseList() {
  if (!courses.value.length && store.organization?.id) {
    getExperimentCourseList({ organ_id: store.organization.id }).then((res: any) => {
      courses.value = res.data
    })
  }
  return { courses }
}
