import { getExperimentTeacherList } from '../api'

import { useUserStore } from '@/stores/user'

interface TeacherType {
  id: string
  name: string
}
const store = useUserStore()

const teachers = ref<TeacherType[]>([])

export function useGetTeacherList() {
  if (!teachers.value.length && store.organization?.id) {
    getExperimentTeacherList({ organ_id: store.organization.id }).then((res: any) => {
      teachers.value = res.data
    })
  }
  return { teachers }
}
