import type { IMenuItem } from '@/types'
import { defineStore } from 'pinia'
import { useUserStore } from '@/stores/user'

interface State {
  studentMenus: IMenuItem[]
  adminMenus: IMenuItem[]
}

// 学生菜单
const studentMenus: IMenuItem[] = [
  {
    name: '智能营销',
    path: '/student/lab'
  }
  // {
  //   name: '智能陪练',
  //   path: '/student/ai'
  // },
  // {
  //   name: '成绩分析',
  //   path: '/admin/contest/score'
  // },
  // {
  //   name: '技能大赛',
  //   path: '/student/contest'
  // }
]
// 教师、管理员菜单
const adminMenus: IMenuItem[] = [
  {
    name: '智能营销',
    path: '/admin/lab',
    tag: 'v1-teacher',
    children: [
      {
        name: '实验指导书管理',
        path: '/admin/lab/book',
        tag: 'v1-teacher-book'
      },
      {
        name: '实验操作视频管理',
        path: '/admin/lab/video',
        tag: 'v1-teacher-video'
      },
      {
        name: '实验讨论交流',
        path: '/admin/lab/discuss',
        tag: 'v1-teacher-discussion'
      },
      {
        name: '实验成绩管理',
        path: '/admin/lab/record',
        tag: 'v1-teacher-record'
      }
    ]
  },
  // {
  //   name: '智能陪练',
  //   path: '/admin/ai'
  // },
  // {
  //   name: '成绩分析',
  //   path: '/admin/contest/score'
  // },
  // {
  //   name: '技能大赛',
  //   path: '/admin/contest'
  // },
  {
    name: '系统管理',
    path: '/admin/system',
    tag: 'v1-backend-experiment',
    children: [
      {
        name: '实验管理',
        path: '/admin/system/experiment',
        tag: 'v1-backend-experiment'
      }
    ]
  }
]

export const useMenuStore = defineStore({
  id: 'menu',
  state: (): State => ({
    studentMenus,
    adminMenus
  }),
  getters: {
    menus: state => {
      const userStore = useUserStore()
      return userStore.role?.id === 5 ? state.adminMenus : state.studentMenus
    }
  },
  actions: {}
})
