import httpRequest from '@/utils/axios'

// 获取用户信息
export function getUser() {
  return httpRequest.get('/api/lab/v1/common/permission/role')
}

// 退出登录
export function logout() {
  return httpRequest.get('/api/passport/rest/logout')
}

// 获取oss token
export function getToken() {
  return httpRequest.get('/api/usercenter/aliyun/assume-role')
}

// 获取oss signature
export function getSignature() {
  return httpRequest.get('/api/usercenter/aliyun/get-signature')
}

// 图片上传
export function uploadFile(data: Record<string, any>) {
  return httpRequest
    .post('https://webapp-pub.oss-cn-beijing.aliyuncs.com', data, {
      withCredentials: false,
      headers: { 'Content-Type': 'multipart/form-data' }
    })
    .then(() => data)
}
// 获取公共字典列表
export function getMapList() {
  return httpRequest.get('/api/resource/v1/util/get-data-dictionary-list')
}

// 获取上传视频凭证
export function getUploadVideoAuth(data: { title: string; file_name: string }) {
  return httpRequest.post('/api/lab/v1/teacher/video/auth-create', data)
}

// 刷新上传视频的地址凭证
export function updateUploadVideoAuth(data: { source_id: string }) {
  return httpRequest.post('/api/lab/v1/teacher/video/create-auth', data)
}

// 获取项目列表
export function getProjectList(params: { organization_id?: string; project_id?: string }) {
  return httpRequest.get('/api/resource/v1/util/members', { params })
}
