import { getExperimentTeacherList } from '../api'

import { useUserStore } from '@/stores/user'

interface TeacherType {
  id: string
  name: string
}
const store = useUserStore()

const teachers = ref<TeacherType[]>([])

export function useGetTeacherList() {
  !teachers.value.length &&
    getExperimentTeacherList({ organ_id: store.organization?.id }).then((res: any) => {
      teachers.value = res.data
    })
  return { teachers }
}
