import type { Component } from 'vue'

export interface IMenuItem {
  tag?: string
  name: string
  path: string
  icon?: Component
  children?: IMenuItem[]
}

// 用户信息
export interface UserType {
  id: string
  mobile: string
  name: string
  email: string
  username: string
  avatar: string
}

// 项目信息
export interface ProjectType {
  id: string
  tab: string
  name: string
}

// 机构信息
export interface OrganizationType {
  id: string
  name: string
  contact_name: string
  contact_information: string
  validity_date: string
  is_valid: 1 | 2
}

// 角色信息
export interface RoleType {
  id: string
  name: string
  desc: string
}

// 权限信息
export interface PermissionType {
  desc: string
  effect_uris: string
  id: string
  name: string
  parent_id: string
  system_tag: number
  type: number
  tag: string
}
