import type { RouteRecordRaw } from 'vue-router'
import AppLayout from '@/components/layout/Index.vue'

export const routes: Array<RouteRecordRaw> = [
  {
    path: '/admin/contest',
    redirect: '/admin/contest/items'
  },
  {
    path: '/admin/contest/items',
    component: AppLayout,
    children: [
      { path: '', component: () => import('./views/Index.vue') },
      { path: ':id', component: () => import('./views/View.vue'), props: true },
      { path: 'edit/:id', component: () => import('./views/Edit.vue'), props: true }
    ]
  }
]
