import httpRequest from '@/utils/axios'

// 获取讨论交流列表
export function getDiscussList(params?: {
  course_id?: string
  experiment_id?: string
  specialty_id?: string
  class_id?: string
  student_name?: string
  page?: number
  page_size?: number
}) {
  return httpRequest.get('/api/lab/v1/teacher/discussion/list', { params })
}

// 获取筛选条件
export function getFilterList() {
  return httpRequest.get('/api/lab/v1/teacher/discussion/search-list')
}

// 获取讨论交流详情
export function getDiscuss(params: { id: string; page?: number; page_size?: number }) {
  return httpRequest.get('/api/lab/v1/teacher/discussion/view', { params })
}

// 获取讨论交流详情
export function submitDiscussComment(data: { id: string; content: string }) {
  return httpRequest.post('/api/lab/v1/teacher/discussion/comment', data)
}
