import { getExperimentTeacherList } from '../api'

interface TeacherType {
  id: string
  name: string
  sso_id: string
}

export function useGetTeacherList() {
  const teachers = ref<TeacherType[]>([])
  function updateTeachers(organId: string) {
    getExperimentTeacherList({ organ_id: organId }).then((res: any) => {
      teachers.value = res.data
    })
  }
  return { teachers, updateTeachers }
}
