const appConfigList = [
  {
    title: '商业数据分析实验室',
    logo: 'https://zws-imgs-pub.ezijing.com/pc/base/ezijing-logo.svg',
    hosts: ['saas-lab']
  },
  {
    system: 'x',
    title: '1+X实训平台',
    logo: 'https://zws-imgs-pub.ezijing.com/pc/base/ezijing-logo.svg',
    hosts: ['saas-x'],
    studentMenus: [
      { name: '首页', path: '/' },
      { name: '我的实验', path: '/student/lab' },
      { name: '理论学习', path: import.meta.env.VITE_SAAS_LEARN_URL }
    ],
    adminMenus: [
      { name: '首页', path: '/' },
      {
        name: '我的实验',
        path: '/admin/lab',
        tag: ['v1-backend-experiment', 'v1-teacher'],
        children: [
          { name: '实验管理', path: '/admin/lab/experiment', tag: 'v1-backend-experiment' },
          { name: '案例原文管理', path: '/admin/lab/case', tag: 'teacher-experiment-cases' },
          { name: '实验指导书管理', path: '/admin/lab/book', tag: 'v1-teacher-book' },
          { name: '实验操作视频管理', path: '/admin/lab/video', tag: 'v1-teacher-video' },
          { name: '实验讨论交流', path: '/admin/lab/discuss', tag: 'v1-teacher-discussion' },
          { name: '实验成绩管理', path: '/admin/lab/score', tag: 'v1-teacher-record' }
        ]
      }
    ]
  },
  {
    system: 'game',
    title: '商业数据分析竞赛平台',
    hosts: ['saas-game']
  },
  {
    system: 'dml',
    title: '数字营销实验室',
    logo: 'https://zws-imgs-pub.ezijing.com/pc/base/ezijing-logo.svg',
    hosts: ['saas-dml-web'],
    dmlURL: import.meta.env.VITE_DML_PRO_URL
  },
  {
    system: 'swsjfxs',
    title: '商务数据分析师',
    logo: 'https://webapp-pub.ezijing.com/website/base/images/logo_swsjfxs.png',
    favicon: 'https://webapp-pub.ezijing.com/website/base/images/favicon_swsjfxs.png',
    hosts: ['swsjfxs'],
    studentMenus: [
      { name: '首页', path: '/' },
      { name: '我的大赛', path: '/student/contest' },
      { name: '大赛成绩查询', path: '/student/contest/score' }
    ],
    xTrainLabel: '商务数据分析理论训练',
    labTrainLabel: '商务数据分析实操训练',
    xExamLabel: '商务数据分析理论考试',
    labExamLabel: '商务数据分析实操考试',
    loginURL: import.meta.env.VITE_SWSJFXS_LOGIN_URL
  }
]

export function useAppConfig() {
  const found = appConfigList.find(item => {
    return item.hosts.find(host => location.host.includes(host))
  })

  const appConfig = found || appConfigList[0]

  return { ...appConfig }
}
