import { getFilterList } from '../api'

export interface FilterItem {
  id: string
  name: string
}
// 课程
const courses = ref<FilterItem[]>([])
// 实验
const experiments = ref<FilterItem[]>([])
// 专业
const specialties = ref<FilterItem[]>([])
// 班级
const classes = ref<FilterItem[]>([])

export function useFilterList() {
  getFilterList().then(res => {
    courses.value = res.data.courses
    experiments.value = res.data.experiments
    specialties.value = res.data.specialties
    classes.value = res.data.classes
  })
  return { courses, experiments, specialties, classes }
}
