import httpRequest from '@/utils/axios'
import type { ContestantCreateParams, ContestantUpdateParams } from './types'
// 获取参赛选手列表
export function getContestantList(params?: { name?: string; page?: number; 'per-page'?: number }) {
  return httpRequest.get('/api/resource/v1/backend/experiment/list', { params })
}

// 创建参赛选手
export function createContestant(data: ContestantCreateParams) {
  return httpRequest.post('/api/resource/v1/backend/experiment/list', data)
}

// 修改参赛选手
export function updateContestant(data: ContestantUpdateParams) {
  return httpRequest.post('/api/resource/v1/backend/experiment/list', data)
}

// 获取参赛选手列表
export function uploadContestant(data: { file: File }) {
  return httpRequest.post('/api/resource/v1/backend/experiment/list', data)
}
