import httpRequest from '@/utils/axios'
import type { JudgeCreateParams, JudgeUpdateParams } from './types'

// 获取评分专家列表
export function getJudgeList(params?: { name?: string; page?: number; 'per-page'?: number }) {
  return httpRequest.get('/api/resource/v1/backend/experiment/list', { params })
}

// 创建评分专家
export function createJudge(data: JudgeCreateParams) {
  return httpRequest.post('/api/resource/v1/backend/experiment/list', data)
}

// 修改评分专家
export function updateJudge(data: JudgeUpdateParams) {
  return httpRequest.post('/api/resource/v1/backend/experiment/list', data)
}

// 获取评分专家列表
export function uploadJudge(data: { file: File }) {
  return httpRequest.post('/api/resource/v1/backend/experiment/list', data)
}
