import { getExperimentCourseList } from '../api'


interface CourseType {
  id: string
  name: string
}

export function useGetCourseList() {
  const courses = ref<CourseType[]>([])
  function updateCourses(organId: string) {
    getExperimentCourseList({ organ_id: organId }).then((res: any) => {
      courses.value = res.data
    })
  }
  return { courses, updateCourses }
}
