import type { RouteRecordRaw } from 'vue-router'
import AppLayout from '@/components/layout/Index.vue'

export const routes: Array<RouteRecordRaw> = [
  {
    path: '/teacher/lab',
    redirect: '/teacher/lab/book'
  },
  {
    path: '/teacher/lab/book',
    component: AppLayout,
    children: [
      { path: '', component: () => import('./views/Index.vue') },
      { path: ':id', component: () => import('./views/View.vue'), props: true }
    ]
  }
]
