import fs from 'node:fs'
import path from 'node:path'
import axios from 'axios'

const __dirname = path.resolve()

const domain = 'segcdc.com'

const outputPath = './https'

// 生成文件夹
function genOutputDir() {
  if (fs.existsSync(outputPath)) {
    console.log('The path exists.')
  } else {
    fs.mkdir(outputPath, { recursive: true }, err => {
      if (err) throw err
    })
  }
}

function downloadCertFile() {
  genOutputDir()
  axios.get(`https://ssl.godzyx.com/${domain}/privkey.pem?get=allow`, { responseType: 'stream' }).then(response => {
    response.data.pipe(fs.createWriteStream(path.join(__dirname, `${outputPath}/${domain}.key`)))
  })

  axios.get(`https://ssl.godzyx.com/${domain}/fullchain.pem?get=allow`, { responseType: 'stream' }).then(response => {
    response.data.pipe(fs.createWriteStream(path.join(__dirname, `${outputPath}/${domain}.pem`)))
  })
}
downloadCertFile()
