export function useCountdown(optionsSecond = 90) {
  const second = ref(optionsSecond)
  const disabled = ref(false)
  let timer: number | null = null

  function start() {
    disabled.value = true
    timer = window.setInterval(() => {
      second.value--
      if (second.value <= 0) {
        stop()
      }
    }, 1000)
  }
  function stop() {
    timer && clearInterval(timer)
    disabled.value = false
  }

  onUnmounted(() => {
    timer && clearInterval(timer)
    timer = null
  })

  return { second, disabled, start, stop }
}
