import httpRequest from '@/utils/axios'

// 获取实验记录列表
export function getExperimentRecordList(params?: {
  course_id?: string
  experiment_id?: string
  specialty_id?: string
  class_id?: string
  student_name?: string
  page?: number
  page_size?: number
}) {
  return httpRequest.get('/api/lab/v1/expert/check/list', { params })
}

// 获取筛选条件
export function getFilterList(params?: { leader?: number }) {
  return httpRequest.get('/api/lab/v1/expert/check/condition', { params })
}

// 获取实验记录详情
export function getExperimentRecord(params: { experiment_id: string; student_id: string }) {
  return httpRequest.get('/api/lab/v1/teacher/record/view', { params })
}

// 实验记录评分
export function checkExperimentRecord(data: {
  experiment_id: string
  student_id: string
  operate: number
  result: number
  file: number
}) {
  return httpRequest.post('/api/lab/v1/teacher/record/check', data)
}

// 批量导入实验记录评分
export function uploadCheckExperimentRecord(data: { file: File }) {
  return httpRequest.post('/api/lab/v1/teacher/record/upload', data, {
    headers: { 'Content-Type': 'multipart/form-data' }
  })
}
