import { getFilterList } from '../api'

export interface FilterItem {
  id: string
  name: string
}
// 赛项
const competitions = ref<FilterItem[]>([])
// 学校
const schools = ref<FilterItem[]>([])
// 状态
const status = ref<FilterItem[]>([])

export function useFilterList() {
  getFilterList().then(res => {
    competitions.value = res.data.competition
    schools.value = res.data.school
    status.value = res.data.status
  })
  return { competitions, schools, status }
}
