import type { IMenuItem } from '@/types'
import { defineStore } from 'pinia'
import { useUserStore } from '@/stores/user'

interface State {
  studentMenus: IMenuItem[]
  adminMenus: IMenuItem[]
  teacherMenus: IMenuItem[]
}

// 学生菜单
const studentMenus: IMenuItem[] = [
  {
    name: '智能营销',
    path: '/student/lab'
  },
  {
    name: '技能大赛',
    path: '/student/contest'
  }
]
// 教师、专家菜单
const teacherMenus: IMenuItem[] = [
  {
    name: '智能营销',
    path: '/teacher/lab',
    tag: 'v1-teacher',
    children: [
      {
        name: '实验指导书管理',
        path: '/teacher/lab/book',
        tag: 'v1-teacher-book'
      },
      {
        name: '实验操作视频管理',
        path: '/teacher/lab/video',
        tag: 'v1-teacher-video'
      },
      {
        name: '实验讨论交流',
        path: '/teacher/lab/discuss',
        tag: 'v1-teacher-discussion'
      },
      {
        name: '实验成绩管理',
        path: '/teacher/lab/record',
        tag: 'v1-teacher-record'
      }
    ]
  },
  {
    name: '技能大赛',
    path: '/teacher/contest',
    children: [
      {
        name: '训练答疑',
        path: '/teacher/contest/discuss'
      },
      {
        name: '大赛评分',
        path: '/teacher/contest/record'
      },
      {
        name: '发布成绩',
        path: '/teacher/contest/score'
      }
    ]
  }
]
// 管理员菜单
const adminMenus: IMenuItem[] = [
  {
    name: '智能营销',
    path: '/admin/lab',
    tag: 'v1-backend-experiment',
    children: [
      {
        name: '实验管理',
        path: '/admin/lab/experiment',
        tag: 'v1-backend-experiment'
      }
    ]
  },
  {
    name: '技能大赛',
    path: '/admin/contest',
    children: [
      {
        name: '赛项管理',
        path: '/admin/contest/items'
      },
      {
        name: '参赛选手管理',
        path: '/admin/contest/contestants'
      },
      {
        name: '评分专家管理',
        path: '/admin/contest/experts'
      }
    ]
  }
]

export const useMenuStore = defineStore({
  id: 'menu',
  state: (): State => ({
    studentMenus,
    adminMenus,
    teacherMenus
  }),
  getters: {
    menus: state => {
      const userStore = useUserStore()
      if (userStore.role?.id === 6) {
        return state.adminMenus
      } else if (userStore.role?.id === 5) {
        return state.teacherMenus
      } else {
        return state.studentMenus
      }
    }
  },
  actions: {}
})
