import httpRequest from '@/utils/axios'
import type { BookCreateItem } from './types'

// 获取课程列表
export function getCourseList() {
  return httpRequest.get('/api/lab/v1/teacher/book/courses')
}
// 获取实验列表
export function getExperimentList(params: { course_id?: string }) {
  return httpRequest.get('/api/lab/v1/teacher/book/experiments', { params })
}
// 获取指导书列表
export function getBookList(params?: { name?: string; experiment_id?: string; page?: number; page_size?: number }) {
  return httpRequest.get('/api/lab/v1/teacher/book/list', { params })
}
// 获取指导书详情
export function getBook(params: { id: string }) {
  return httpRequest.get('/api/lab/v1/teacher/book/view', { params })
}

// 创建指导书
export function createBook(data: BookCreateItem) {
  return httpRequest.post('/api/lab/v1/teacher/book/create', data)
}

// 更新指导书
export function updateBook(data: BookCreateItem) {
  return httpRequest.post('/api/lab/v1/teacher/book/update', data)
}
